<?php
/**
 * Fluent Booking Pro Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_Fluent_Booking_Pro
 */
class HelloPack_Module_Fluent_Booking_Pro extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'fluent-booking-pro';
		$this->name        = 'Fluent Booking Pro';
		$this->description = __( 'Manages Fluent Booking Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'fluent-booking-pro',
			'plugin_file' => 'fluent-booking-pro.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->activate_license();
	}

	/**
	 * Activate Fluent Booking Pro license.
	 */
	private function activate_license() {
		$booking_data = array(
			'license_key' => HP_GLOBAL_SERIAL,
			'price_id'    => '',
			'expires'     => gmdate( 'Y-m-d H:i:s', strtotime( '+1 year' ) ),
			'status'      => 'valid',
		);

		HP_check_options( '__fluent_booking_pro_license', $booking_data );
	}
}