<?php
/**
 * FluentCart Pro Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_Fluent_Cart_Pro
 */
class HelloPack_Module_Fluent_Cart_Pro extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'fluent-cart-pro';
		$this->name        = 'FluentCart Pro';
		$this->description = __( 'Manages FluentCart Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'fluent-cart-pro',
			'plugin_file' => 'fluent-cart-pro.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->activate_license();
	}

	/**
	 * Activate FluentCart Pro license.
	 */
	private function activate_license() {
		$license_data = array(
			'license_key' => HP_GLOBAL_SERIAL,
			'price_id'    => '',
			'expires'     => date( 'Y-m-d H:i:s', strtotime( '+10 years' ) ),
			'status'      => 'valid',
		);

		HP_check_options( '__fluent-cart-pro_sl_info', $license_data );

		// Set last check timestamp to avoid remote verification
		HP_check_options( '_fct_pro_plugin_license_lc', time() );
	}
}
