<?php
/**
 * Fluent Community Pro Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Fluent Community Pro module class.
 */
class HelloPack_Module_Fluent_Community_Pro extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'fluent-community-pro';
		$this->name        = __( 'Fluent Community Pro', 'hellopack-client' );
		$this->description = __( 'Manages Fluent Community Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'fluent-community-pro',
			'plugin_file' => 'fluent-community-pro.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		// Setup license
		$this->activate_license();

		// Setup API servers
		$this->setup_api_servers();
	}

	/**
	 * Activate Fluent Community Pro license
	 */
	private function activate_license() {
		$license_data = array(
			'license_key' => defined( 'HP_GLOBAL_SERIAL' ) ? HP_GLOBAL_SERIAL : '',
			'price_id'    => '',
			'expires'     => 'lifetime',
			'status'      => 'valid',
		);

		HP_check_options( '__fluent_community_pro_license', $license_data );
	}

	/**
	 * Setup API servers for Fluent Community Pro
	 */
	private function setup_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$fluentcommunity = new HPack_Set_API_Servers();
			$fluentcommunity->set_api_servers(
				'api3.wpmanageninja.com/plugin',
				HP_PLUGIN_REGISTER_SERVER . '/fluentcommunity'
			);
			$fluentcommunity->init();
		}
	}
}