<?php
/**
 * GenerateBlocks Pro Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_GenerateBlocks_Pro
 */
class HelloPack_Module_GenerateBlocks_Pro extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'generateblocks-pro';
		$this->name        = 'GenerateBlocks Pro';
		$this->description = __( 'Manages GenerateBlocks Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'generateblocks-pro',
			'plugin_file' => 'plugin.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->activate_license();
	}

	/**
	 * Activate GenerateBlocks Pro license.
	 */
	private function activate_license() {
		$generate = array(
			'key'    => HP_GLOBAL_SERIAL,
			'status' => 'valid',
			'beta'   => false,
		);
		HP_check_options( 'generateblocks_pro_licensing', $generate );
	}
}