<?php
/**
 * GP Premium Module
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_GP_Premium
 */
class HelloPack_Module_GP_Premium extends HelloPack_Module_Base {

	/**
	 * Set up the module properties.
	 */
	protected function setup() {
		$this->id          = 'gp-premium';
		$this->name        = 'GP Premium';
		$this->description = __( 'Manages GP Premium updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'gp-premium',
			'plugin_file' => 'gp-premium.php',
		);
	}

	/**
	 * Initialize the module functionality.
	 */
	public function init() {
		if ( ! $this->should_load() ) {
			return;
		}

		$this->activate_license();
	}

	/**
	 * Activate GP Premium license.
	 */
	private function activate_license() {
		HP_check_options( 'gen_premium_license_key', '61f1be33598b9644de31e3214c9d15fb' );
		HP_check_options( 'gen_premium_license_key_status', 'valid' );
	}
}