<?php
/**
 * iThemes Security Pro Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * iThemes Security Pro module class.
 */
class HelloPack_Module_IThemes_Security_Pro extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'ithemes-security-pro';
		$this->name        = __( 'iThemes Security Pro', 'hellopack-client' );
		$this->description = __( 'Manages iThemes Security Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'ithemes-security-pro',
			'plugin_file' => 'ithemes-security-pro.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Set API servers
		$security = new HPack_Set_API_Servers();
		$security->over_api_servers( 'api.ithemes.com/updater' );
		$security->init();
	}
}