<?php
/**
 * OxyExtras Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * OxyExtras module class.
 */
class HelloPack_Module_OxyExtras extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'oxyextras';
		$this->name        = __( 'OxyExtras', 'hellopack-client' );
		$this->description = __( 'Manages OxyExtras updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'oxyextras',
			'plugin_file' => 'oxy-extras.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Check and set OxyExtras plugin status
		$this->check_plugin_status();
	}

	/**
	 * Check and set OxyExtras plugin status
	 */
	private function check_plugin_status() {
		if ( function_exists( 'HP_check_options' ) ) {
			HP_check_options( 'oxy_extras_license_key', HP_GLOBAL_SERIAL );
			HP_check_options( 'oxy_extras_license_status', 'valid' );
		}
	}
}