<?php
/**
 * Revolution Slider Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Revolution Slider module class.
 */
class HelloPack_Module_RevSlider extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'revslider';
		$this->name        = __( 'Revolution Slider', 'hellopack-client' );
		$this->description = __( 'Manages Revolution Slider updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'revslider',
			'plugin_file' => 'revslider.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Override API servers
		$this->override_api_servers();
		
		// Set license options
		$this->set_license_options();
	}

	/**
	 * Override API servers
	 */
	private function override_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$revslider = new HPack_Set_API_Servers();
			$revslider->over_api_servers( 'updates.themepunch.tools' );
			$revslider->init();

			$revslider_a = new HPack_Set_API_Servers();
			$revslider_a->over_api_servers( 'library.themepunch.tools' );
			$revslider_a->init();

			$revslider_b = new HPack_Set_API_Servers();
			$revslider_b->over_api_servers( 'templates.themepunch.tools' );
			$revslider_b->init();

			$revslider_c = new HPack_Set_API_Servers();
			$revslider_c->over_api_servers( 'themepunch.tools' );
			$revslider_c->init();
		}
	}

	/**
	 * Set license options
	 */
	private function set_license_options() {
		if ( function_exists( 'HP_check_options' ) ) {
			HP_check_options( 'revslider-valid', 'true' );
			HP_check_options( 'revslider-code', HP_GLOBAL_SERIAL );
			HP_check_options( 'revslider-temp-active-notice', 'false' );
		}
	}
}