<?php
/**
 * ThePlus Elementor Addon Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * ThePlus Elementor Addon module class.
 */
class HelloPack_Module_ThePlus_Elementor_Addon extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'theplus-elementor-addon';
		$this->name        = __( 'ThePlus Elementor Addon', 'hellopack-client' );
		$this->description = __( 'Manages ThePlus Elementor Addon updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'theplus_elementor_addon',
			'plugin_file' => 'theplus_elementor_addon.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Set license options
		$this->set_license_options();
	}

	/**
	 * Set license options
	 */
	private function set_license_options() {
		if ( function_exists( 'HP_check_options' ) ) {
			HP_check_options(
				'theplus_verified',
				array(
					'expire'  => 'lifetime',
					'license' => 'valid',
					'verify'  => 1,
				)
			);
			HP_check_options( 'theplus_purchase_code', array( 'tp_api_key' => HP_GLOBAL_SERIAL ) );
		}
	}
}