<?php
/**
 * Tutor LMS Pro Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Tutor LMS Pro module class.
 */
class HelloPack_Module_TutorLMS extends HelloPack_Module_Base {

	/**
	 * TutorLMS Update instance reference
	 *
	 * @var object
	 */
	private $tutor_updater_instance = null;

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'tutor-pro';
		$this->name        = __( 'Tutor LMS Pro', 'hellopack-client' );
		$this->description = __( 'Manages Tutor LMS Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'tutor-pro',
			'plugin_file' => 'tutor-pro.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Set license info
		$this->set_license_info();

		// Remove Tutor LMS update related filters and actions with high priority
		add_action( 'init', array( $this, 'remove_tutor_update_hooks' ), 999 );
		add_action( 'admin_init', array( $this, 'remove_tutor_update_hooks' ), 999 );
	}

	/**
	 * Set Tutor LMS license info
	 */
	private function set_license_info() {
		if ( function_exists( 'HP_check_options' ) ) {
			$license_data = array(
				'access_token'      => HP_GLOBAL_SERIAL,
				'refresh_token'     => HP_GLOBAL_SERIAL,
				'tokens_expires_at' => date( 'Y-m-d H:i:s', strtotime( '+10 years' ) ),
				'activated'         => true,
				'license_key'       => HP_GLOBAL_SERIAL,
				'customer_name'     => 'HelloPack License',
				'expires_at'        => date( 'Y-m-d H:i:s', strtotime( '+10 years' ) ),
				'activated_at'      => date( 'Y-m-d H:i:s' ),
				'license_type'      => 'Agency',
			);

			HP_check_options( 'tutor_license_info', $license_data );

			// Set transient to avoid repeated API calls
			set_transient( 'tutor_license_transient_key', $license_data, DAY_IN_SECONDS );
		}
	}

	/**
	 * Remove Tutor LMS specific update hooks
	 */
	public function remove_tutor_update_hooks() {
		global $wp_filter;

		if ( ! class_exists( 'TutorPRO\ThemeumUpdater\Update' ) ) {
			return;
		}

		// Get the TutorLMS Update class instance
		$tutor_update_class = 'TutorPRO\ThemeumUpdater\Update';

		// Remove hooks specifically added by TutorLMS Update class
		if ( isset( $wp_filter['plugins_api'] ) ) {
			foreach ( $wp_filter['plugins_api']->callbacks as $priority => $callbacks ) {
				foreach ( $callbacks as $id => $callback ) {
					if ( is_array( $callback['function'] ) &&
						 is_object( $callback['function'][0] ) &&
						 get_class( $callback['function'][0] ) === $tutor_update_class ) {
						remove_filter( 'plugins_api', $callback['function'], $priority );
					}
				}
			}
		}

		// Remove pre_set_site_transient_update_plugins hook
		if ( isset( $wp_filter['pre_set_site_transient_update_plugins'] ) ) {
			foreach ( $wp_filter['pre_set_site_transient_update_plugins']->callbacks as $priority => $callbacks ) {
				foreach ( $callbacks as $id => $callback ) {
					if ( is_array( $callback['function'] ) &&
						 is_object( $callback['function'][0] ) &&
						 get_class( $callback['function'][0] ) === $tutor_update_class ) {
						remove_filter( 'pre_set_site_transient_update_plugins', $callback['function'], $priority );
					}
				}
			}
		}

		// Remove site_transient_update_plugins hook
		if ( isset( $wp_filter['site_transient_update_plugins'] ) ) {
			foreach ( $wp_filter['site_transient_update_plugins']->callbacks as $priority => $callbacks ) {
				foreach ( $callbacks as $id => $callback ) {
					if ( is_array( $callback['function'] ) &&
						 is_object( $callback['function'][0] ) &&
						 get_class( $callback['function'][0] ) === $tutor_update_class ) {
						remove_filter( 'site_transient_update_plugins', $callback['function'], $priority );
					}
				}
			}
		}

		// Remove upgrader_pre_download hook (prevents license check before download)
		if ( isset( $wp_filter['upgrader_pre_download'] ) ) {
			foreach ( $wp_filter['upgrader_pre_download']->callbacks as $priority => $callbacks ) {
				foreach ( $callbacks as $id => $callback ) {
					if ( is_array( $callback['function'] ) &&
						 is_object( $callback['function'][0] ) &&
						 get_class( $callback['function'][0] ) === $tutor_update_class ) {
						remove_filter( 'upgrader_pre_download', $callback['function'], $priority );
					}
				}
			}
		}

		// Remove in_plugin_update_message hook
		remove_all_filters( 'in_plugin_update_message-tutor-pro/tutor-pro.php' );

		// Remove AJAX actions
		remove_all_actions( 'wp_ajax_delete_tutor_license' );
		remove_all_actions( 'wp_ajax_update_tutor_license' );
		remove_all_actions( 'wp_ajax_tutor_oauth_check' );

		// Remove current_screen action that forces update check
		if ( isset( $wp_filter['current_screen'] ) ) {
			foreach ( $wp_filter['current_screen']->callbacks as $priority => $callbacks ) {
				foreach ( $callbacks as $id => $callback ) {
					if ( is_array( $callback['function'] ) &&
						 is_object( $callback['function'][0] ) &&
						 get_class( $callback['function'][0] ) === $tutor_update_class ) {
						remove_action( 'current_screen', $callback['function'], $priority );
					}
				}
			}
		}
	}
}