<?php
/**
 * Ultimate Elementor Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Ultimate Elementor module class.
 */
class HelloPack_Module_Ultimate_Elementor extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'ultimate-elementor';
		$this->name        = __( 'Ultimate Elementor', 'hellopack-client' );
		$this->description = __( 'Manages Ultimate Elementor updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'ultimate-elementor',
			'plugin_file' => 'ultimate-elementor.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Hide Ultimate Elementor admin notices
		$this->hide_admin_notices();
		
		// Set Ultimate Elementor license
		$this->set_ultimate_elementor_license();
		
		// Override API servers
		$this->override_api_servers();
	}

	/**
	 * Hide Ultimate Elementor admin notices
	 */
	private function hide_admin_notices() {
		if ( class_exists( 'HelloPackCSSDisable' ) ) {
			$ultimate_notice = new HelloPackCSSDisable();
			$ultimate_notice->add_selector( '#ultimate-elementor-update i' );
			$ultimate_notice->hide_notices();
		}
	}

	/**
	 * Set Ultimate Elementor license status
	 */
	private function set_ultimate_elementor_license() {
		// Get brainstormforce products option
		$brainstrom_products = get_option( 'brainstrom_products' );
		
		// Check if plugins and uael keys exist
		if ( isset( $brainstrom_products['plugins'] ) && isset( $brainstrom_products['plugins']['uael'] ) ) {
			// Add or update the 'status' key with 'registered' value
			$brainstrom_products['plugins']['uael']['status'] = 'registered';
			
			// Update the brainstrom_products option
			update_option( 'brainstrom_products', $brainstrom_products );
		}
	}

	/**
	 * Override API servers
	 */
	private function override_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$brainstormforce = new HPack_Set_API_Servers();
			$brainstormforce->over_api_servers( 'support.brainstormforce.com' );
			// Note: init() is commented out in legacy code
			// $brainstormforce->init();
		}
	}
}