<?php
/**
 * WP Analytify Pro Module
 *
 * @package HelloPack_Client
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * WP Analytify Pro module class.
 */
class HelloPack_Module_WP_Analytify_Pro extends HelloPack_Module_Base {

	/**
	 * Setup module properties
	 */
	protected function setup() {
		$this->id          = 'wp-analytify-pro';
		$this->name        = __( 'WP Analytify Pro', 'hellopack-client' );
		$this->description = __( 'Manages WP Analytify Pro updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'wp-analytify-pro',
			'plugin_file' => 'wp-analytify-pro.php',
		);
	}

	/**
	 * Initialize the module
	 */
	public function init() {
		// Override API servers
		$this->override_api_servers();
	}

	/**
	 * Override API servers
	 */
	private function override_api_servers() {
		if ( class_exists( 'HPack_Set_API_Servers' ) ) {
			$analytify = new HPack_Set_API_Servers();
			$analytify->over_api_servers( 'analytify.io' );
			$analytify->init();
		}
	}
}