<?php
/**
 * HelloPack Module: WPAlliee
 *
 * @package HelloPack
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Class HelloPack_Module_WPAlliee
 *
 * Module for managing WP All Export Pro & WP All Import Pro plugins
 */
class HelloPack_Module_WPAlliee extends HelloPack_Module_Base {

	/**
	 * Module setup
	 *
	 * @return void
	 */
	public function setup() {
		$this->id          = 'wpalliee';
		$this->name        = 'WPAlliee';
		$this->description = __( 'Manages WPAlliee updates through centralized updater.', 'hellopack-client' );
		$this->category    = 'plugin';
		$this->version     = '1.0.0';
		$this->target      = array(
			'plugin_dir'  => 'wp-all-import-pro',
			'plugin_file' => 'wp-all-import-pro.php',
		);
	}

	/**
	 * Module initialization
	 *
	 * @return void
	 */
	public function init() {
		// Check if either plugin is active
		if ( ! $this->should_load() && ! hp_is_plugin_activated( 'wp-all-export-pro', 'wp-all-export-pro.php' ) ) {
			return;
		}

		// Update WP All Export Pro options
		$options = get_option( 'PMXE_Plugin_Options' );
		if ( $options ) {
			$options['license']        = HP_GLOBAL_SERIAL;
			$options['license_status'] = 'valid';
			update_option( 'PMXE_Plugin_Options', $options );
		}

		// Update WP All Import Pro options
		$options = get_option( 'PMXI_Plugin_Options' );
		if ( $options ) {
			$options['licenses']['PMXI_Plugin'] = HP_GLOBAL_SERIAL;
			$options['statuses']['PMXI_Plugin'] = 'valid';
			update_option( 'PMXI_Plugin_Options', $options );
		}

		// Define empty updater classes if they don't exist
		$this->define_updater_classes();
	}

	/**
	 * Define updater classes if they don't exist
	 *
	 * @return void
	 */
	private function define_updater_classes() {
		if ( ! class_exists( 'PMXI_Updater' ) ) {
			eval( 'class PMXI_Updater{}' );
		}

		if ( ! class_exists( 'PMXE_Updater' ) ) {
			eval( 'class PMXE_Updater{}' );
		}
	}
}