# HelloPack Client

A centralized update management solution for WordPress themes and plugins. HelloPack Client provides a unified way to manage updates, licenses, and installations for premium WordPress products.

## Description

HelloPack Client is a WordPress plugin that enables centralized management of premium themes and plugins through the HelloPack service. It provides automatic updates, license management, and easy installation of products from the HelloPack repository.

## Features

- **Centralized Updates**: Manage all your premium plugin and theme updates from one place
- **OAuth Authentication**: Secure token-based authentication system
- **Module System**: Support for 50+ premium plugins with dedicated update modules
- **Network/Multisite Support**: Full compatibility with WordPress multisite installations
- **WP-CLI Integration**: Command-line interface for advanced users
- **Admin Notification Cleaner**: Reduce admin clutter by hiding unnecessary notifications
- **Automatic Reauthorization**: Built-in cron job for maintaining API connection

## Requirements

- WordPress 5.1 or higher
- PHP 7.4 or higher
- cURL PHP extension
- Valid HelloPack API key

## Installation

1. Upload the `hellopack-client` folder to the `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Navigate to the HelloPack settings page
4. Enter your API key from HelloWP.io
5. Start managing your premium themes and plugins

## Usage

### Getting Started

1. **Obtain an API Key**: Log in to your HelloWP.io account and generate an API key
2. **Configure the Plugin**: Enter your API key in the HelloPack settings
3. **Browse Available Items**: View and install available themes and plugins
4. **Manage Updates**: Keep your premium products up to date automatically

### Module Management

The plugin includes modules for popular premium plugins that automatically handle:
- License activation
- Update management
- Compatibility checks

### WP-CLI Commands

```bash
# Check HelloPack status
wp hellopack status

# List available updates
wp hellopack list-updates

# Deactivate HelloPack
wp hellopack deactivate
```

## Changelog

See [changelog.md](changelog.md) for a full list of changes.

## Support

For support, please visit [HelloWP.io](https://hellowp.io) or contact support through your HelloPack dashboard.

## License

This plugin is licensed under GPLv2 or later.