<?php

namespace ToolsetBlocks\Block\Style\Block;

use ToolsetCommonEs\Block\Style\Block\Common;
use ToolsetCommonEs\Library\MobileDetect\MobileDetect;

/**
 * Class Audio
 *
 * @package ToolsetBlocks\Block\Style\Block
 */
class Audio extends Common {
	/**
	 * Returns hardcoded css classes of the block to have a more specific selector.
	 *
	 * @return string
	 */
	public function get_css_block_class() {
		return $this->get_existing_block_classes_as_selector( [ 'tb-audio' ] );
	}

	/**
	 * Css of the block.
	 *
	 * @param array $config
	 * @param false $force_apply
	 * @param null $responsive_device
	 *
	 * @return string
	 */
	public function get_css( $config = [], $force_apply = false, $responsive_device = null ) {
		$css = $this->get_css_file_content( TB_PATH_CSS . '/audio.css' );
		$parent_css = parent::get_css( $config, $force_apply, $responsive_device );

		return ! empty( $parent_css )
			? $css . ' ' . $parent_css
			: $css;
	}


	/**
	 * @param string $content
	 * @param MobileDetect $device_detect
	 *
	 * @return string
	 */
	public function filter_block_content( $content, MobileDetect $device_detect ) {
		if ( ! defined( 'TB_SCRIPT_STYLE_LAZY_LOAD' ) || TB_SCRIPT_STYLE_LAZY_LOAD ) {
			// Replace the src by data-src. On user interaction or when the block is in the viewport 'data-src' is
			// replaced via js to 'src' again. This way it does not delay the page load.
			$content = str_replace( ' src="', ' data-src="', $content );
		}

		return parent::filter_block_content( $content, $device_detect ); // TODO: Change the autogenerated stub
	}
}
